// DO NOT EDIT! This test has been generated by /html/canvas/tools/gentest.py.
// OffscreenCanvas test in a worker:2d.text.measure.fillTextCluster-options.tentative
// Description:Test that fillTextCluster() correctly applies the options passed as a dictionary.
// Note:

importScripts("/resources/testharness.js");
importScripts("/html/canvas/resources/canvas-tests.js");

promise_test(async t => {
  var canvas = new OffscreenCanvas(100, 300);
  var ctx = canvas.getContext('2d');

  var f = new FontFace("CanvasTest", "url('/fonts/CanvasTest.ttf')");
  f.load();
  self.fonts.add(f);
  await self.fonts.ready;

  ctx.font = '50px CanvasTest';
  ctx.textAlign = 'left';
  ctx.textBaseline = 'top';
  const text = 'E';
  const tm = ctx.measureText(text);
  const cluster = tm.getTextClusters()[0];

  // Background color.
  ctx.fillStyle = '#f00';
  ctx.fillRect(0, 0, canvas.width, canvas.height);

  ctx.fillStyle = '#0f0';

  // Override the align and baseline of the cluster.
  ctx.fillTextCluster(cluster, 50, 50, {align: 'right', baseline: 'bottom'});
  _assertPixelApprox(canvas, 5,5, 0,255,0,255, 2);
  _assertPixelApprox(canvas, 45,5, 0,255,0,255, 2);
  _assertPixelApprox(canvas, 5,45, 0,255,0,255, 2);
  _assertPixelApprox(canvas, 45,45, 0,255,0,255, 2);
  _assertPixelApprox(canvas, 55,5, 255,0,0,255, 2);
  _assertPixelApprox(canvas, 5,55, 255,0,0,255, 2);
  _assertPixelApprox(canvas, 55,55, 255,0,0,255, 2);

  // Override the x and y values of the cluster.
  ctx.fillTextCluster(cluster, 0, 100, {x: 10, y: 10});
  _assertPixelApprox(canvas, 15,115, 0,255,0,255, 2);
  _assertPixelApprox(canvas, 55,115, 0,255,0,255, 2);
  _assertPixelApprox(canvas, 15,155, 0,255,0,255, 2);
  _assertPixelApprox(canvas, 55,155, 0,255,0,255, 2);
  _assertPixelApprox(canvas, 65,115, 255,0,0,255, 2);
  _assertPixelApprox(canvas, 15,165, 255,0,0,255, 2);
  _assertPixelApprox(canvas, 65,165, 255,0,0,255, 2);

  // Override the align, baseline, x, and y values of the cluster.
  ctx.fillTextCluster(cluster, 50, 250,
                      {align: 'right', baseline: 'bottom', x: 10,  y: 10});
  _assertPixelApprox(canvas, 15,215, 0,255,0,255, 2);
  _assertPixelApprox(canvas, 55,215, 0,255,0,255, 2);
  _assertPixelApprox(canvas, 15,255, 0,255,0,255, 2);
  _assertPixelApprox(canvas, 55,255, 0,255,0,255, 2);
  _assertPixelApprox(canvas, 65,215, 255,0,0,255, 2);
  _assertPixelApprox(canvas, 15,265, 255,0,0,255, 2);
  _assertPixelApprox(canvas, 65,265, 255,0,0,255, 2);
}, "Test that fillTextCluster() correctly applies the options passed as a dictionary.");
done();
