// DO NOT EDIT! This test has been generated by /html/canvas/tools/gentest.py.
// OffscreenCanvas test in a worker:2d.text.measure.selection-rects-baselines.tentative
// Description:Check that TextMetrics::getSelectionRects() works correctly with textBaseline.
// Note:

importScripts("/resources/testharness.js");
importScripts("/html/canvas/resources/canvas-tests.js");

var t = async_test("Check that TextMetrics::getSelectionRects() works correctly with textBaseline.");
var t_pass = t.done.bind(t);
var t_fail = t.step_func(function(reason) {
    throw reason;
});
t.step(function() {

  var canvas = new OffscreenCanvas(100, 50);
  var ctx = canvas.getContext('2d');

  ctx.font = '50px sans-serif';

  const kBaselines = [
    "top",
    "hanging",
    "middle",
    "alphabetic",
    "ideographic",
    "bottom",
  ];

  const kTexts = [
    'UNAVAILABLE',
    '🏁🎶🏁',
    '）（あ）（',
    '-abcd_',
    'איפה הספרייה?',
    'bidiמתמטיקה'
  ]

  for (const text of kTexts) {
    for (const baseline of kBaselines) {
      const tm = ctx.measureText(text);
      // First character.
      for (const r of tm.getSelectionRects(0, 1)) {
        assert_approx_equals(r.top, -tm.fontBoundingBoxAscent, 1.0);
        assert_approx_equals(r.bottom, tm.fontBoundingBoxDescent, 1.0);
      }
      // Last character.
      for (const r of tm.getSelectionRects(text.length - 1, text.length)) {
        assert_approx_equals(r.top, -tm.fontBoundingBoxAscent, 1.0);
        assert_approx_equals(r.bottom, tm.fontBoundingBoxDescent, 1.0);
      }
      // Whole string.
      for (const r of tm.getSelectionRects(0, text.length)) {
        assert_approx_equals(r.top, -tm.fontBoundingBoxAscent, 1.0);
        assert_approx_equals(r.bottom, tm.fontBoundingBoxDescent, 1.0);
      }
      // Intermediate string.
      for (const r of tm.getSelectionRects(1, text.length - 1)) {
        assert_approx_equals(r.top, -tm.fontBoundingBoxAscent, 1.0);
        assert_approx_equals(r.bottom, tm.fontBoundingBoxDescent, 1.0);
      }
      // Invalid start > end string. Creates 0 width rectangle.
      for (const r of tm.getSelectionRects(3, 2)) {
        assert_approx_equals(r.top, -tm.fontBoundingBoxAscent, 1.0);
        assert_approx_equals(r.bottom, tm.fontBoundingBoxDescent, 1.0);
      }
      for (const r of tm.getSelectionRects(1, 0)) {
        assert_approx_equals(r.top, -tm.fontBoundingBoxAscent, 1.0);
        assert_approx_equals(r.bottom, tm.fontBoundingBoxDescent, 1.0);
      }
    }
  }
  t.done();
});
done();
